/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.advancement;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1263;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_184;
import net.minecraft.class_185;
import net.minecraft.class_1860;
import net.minecraft.class_189;
import net.minecraft.class_193;
import net.minecraft.class_1935;
import net.minecraft.class_1959;
import net.minecraft.class_2035;
import net.minecraft.class_2066;
import net.minecraft.class_2073;
import net.minecraft.class_2090;
import net.minecraft.class_2096;
import net.minecraft.class_2105;
import net.minecraft.class_2119;
import net.minecraft.class_2135;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_5321;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.advancement.Display;
import org.betterx.bclib.api.v2.levelgen.structures.BCLStructure;
import org.betterx.bclib.complexmaterials.WoodenComplexMaterial;
import org.betterx.bclib.items.complex.EquipmentSet;
import org.jetbrains.annotations.ApiStatus;

public class AdvancementManager {
    private static final Map<class_2960, class_161.class_162> ADVANCEMENTS = new HashMap<class_2960, class_161.class_162>();

    public static void register(class_2960 id, class_161.class_162 builder) {
        ADVANCEMENTS.put(id, builder);
    }

    @ApiStatus.Internal
    public static void addAdvancements(Map<class_2960, class_161.class_162> map) {
        for (Map.Entry<class_2960, class_161.class_162> entry : ADVANCEMENTS.entrySet()) {
            if (map.containsKey(entry.getKey())) continue;
            map.put(entry.getKey(), entry.getValue());
        }
    }

    public static class DisplayBuilder {
        Builder base;
        final Display display = new Display();

        DisplayBuilder reset(Builder base) {
            this.base = base;
            this.display.reset();
            return this;
        }

        public DisplayBuilder background(class_2960 value) {
            this.display.background = value;
            return this;
        }

        public DisplayBuilder icon(class_1935 value) {
            this.display.icon = new class_1799(value);
            return this;
        }

        public DisplayBuilder icon(class_1799 value) {
            this.display.icon = value;
            return this;
        }

        public DisplayBuilder title(class_2561 value) {
            this.display.title = value;
            return this;
        }

        public DisplayBuilder description(class_2561 value) {
            this.display.description = value;
            return this;
        }

        public DisplayBuilder showToast() {
            this.display.showToast = true;
            return this;
        }

        public DisplayBuilder hideToast() {
            this.display.showToast = false;
            return this;
        }

        public DisplayBuilder hidden() {
            this.display.hidden = true;
            return this;
        }

        public DisplayBuilder visible() {
            this.display.hidden = false;
            return this;
        }

        public DisplayBuilder announceToChat() {
            this.display.announceChat = true;
            return this;
        }

        public DisplayBuilder hideFromChat() {
            this.display.announceChat = false;
            return this;
        }

        public DisplayBuilder frame(class_189 type) {
            this.display.frame = type;
            return this;
        }

        public DisplayBuilder challenge() {
            return this.frame(class_189.field_1250);
        }

        public DisplayBuilder task() {
            return this.frame(class_189.field_1254);
        }

        public DisplayBuilder goal() {
            return this.frame(class_189.field_1249);
        }

        public Builder endDisplay() {
            this.base.display(this.display.build());
            return this.base;
        }
    }

    public static class Builder {
        private static final ThreadLocal<DisplayBuilder> DISPLAY_BUILDER = ThreadLocal.withInitial(DisplayBuilder::new);
        private static final class_2960 RECIPES_ROOT = class_5797.field_39377;
        private final class_161.class_162 builder = class_161.class_162.method_707();
        private final class_2960 id;
        private final AdvancementType type;
        private boolean canBuild = true;

        private Builder(class_2960 id, AdvancementType type) {
            class_2960 ID;
            if (type == AdvancementType.RECIPE_DECORATIONS) {
                ID = new class_2960(id.method_12836(), "recipes/decorations/" + id.method_12832());
                this.builder.method_708(RECIPES_ROOT);
            } else if (type == AdvancementType.RECIPE_TOOL) {
                ID = new class_2960(id.method_12836(), "recipes/tools/" + id.method_12832());
                this.builder.method_708(RECIPES_ROOT);
            } else {
                ID = id;
            }
            this.id = ID;
            this.type = type;
        }

        public static Builder createEmptyCopy(Builder builder) {
            return new Builder(builder.id, builder.type);
        }

        public static Builder create(class_2960 id) {
            return new Builder(id, AdvancementType.REGULAR);
        }

        public static Builder create(class_2960 id, AdvancementType type) {
            return new Builder(id, type);
        }

        public static Builder create(class_1792 icon) {
            return Builder.create((class_1935)icon, AdvancementType.REGULAR);
        }

        public static Builder create(class_1799 icon) {
            return Builder.create(icon, AdvancementType.REGULAR);
        }

        public static Builder create(class_1935 icon, AdvancementType type) {
            return Builder.create(new class_1799(icon), type);
        }

        public static Builder create(class_1799 icon, AdvancementType type) {
            return Builder.create(icon, type, (DisplayBuilder displayBuilder) -> {});
        }

        public static Builder create(class_1792 icon, AdvancementType type, Consumer<DisplayBuilder> displayAdapter) {
            return Builder.create(new class_1799((class_1935)icon), type, displayAdapter);
        }

        public static Builder create(class_1799 icon, AdvancementType type, Consumer<DisplayBuilder> displayAdapter) {
            class_2960 id = class_2378.field_11142.method_10221((Object)icon.method_7909());
            boolean canBuild = true;
            if (id == null || icon.method_31574(class_1802.field_8162)) {
                canBuild = false;
                id = class_2378.field_11142.method_10137();
            }
            String baseName = "advancements." + id.method_12836() + "." + id.method_12832() + ".";
            Builder b = new Builder(id, type);
            DisplayBuilder displayBuilder = b.startDisplay(icon, (class_2561)class_2561.method_43471((String)(baseName + "title")), (class_2561)class_2561.method_43471((String)(baseName + "description")));
            if (displayAdapter != null) {
                displayAdapter.accept(displayBuilder);
            }
            b = displayBuilder.endDisplay();
            b.canBuild = canBuild;
            return b;
        }

        public static <C extends class_1263, T extends class_1860<C>> Builder createRecipe(T recipe, AdvancementType type) {
            class_1792 item = recipe.method_8110().method_7909();
            return Builder.create(item, type, (DisplayBuilder displayBuilder) -> displayBuilder.hideToast().hideFromChat()).addRecipeUnlockCriterion("has_the_recipe", recipe).startReward().addRecipe(recipe.method_8114()).endReward().requirements(class_193.field_1257);
        }

        public Builder parent(class_161 advancement) {
            this.builder.method_701(advancement);
            return this;
        }

        public Builder parent(class_2960 resourceLocation) {
            this.builder.method_708(resourceLocation);
            return this;
        }

        public DisplayBuilder startDisplay(class_1935 icon) {
            String baseName = "advancements." + this.id.method_12836() + "." + this.id.method_12832() + ".";
            return this.startDisplay(icon, (class_2561)class_2561.method_43471((String)(baseName + "title")), (class_2561)class_2561.method_43471((String)(baseName + "description")));
        }

        public DisplayBuilder startDisplay(class_1935 icon, class_2561 title, class_2561 description) {
            return this.startDisplay(new class_1799(icon), title, description);
        }

        public DisplayBuilder startDisplay(class_1799 icon, class_2561 title, class_2561 description) {
            if (icon == null) {
                this.canBuild = false;
            } else {
                class_2960 id = class_2378.field_11142.method_10221((Object)icon.method_7909());
                if (id == null) {
                    this.canBuild = false;
                }
            }
            DisplayBuilder dp = DISPLAY_BUILDER.get().reset(this);
            return dp.icon(icon).title(title).description(description);
        }

        Builder display(class_185 displayInfo) {
            this.builder.method_693(displayInfo);
            return this;
        }

        public Builder awardRecipe(class_1935 ... items) {
            RewardsBuilder rewardBuilder = this.startReward();
            for (class_1935 item : items) {
                class_2960 id = class_2378.field_11142.method_10221((Object)item.method_8389());
                if (id == null) continue;
                rewardBuilder.addRecipe(id);
            }
            return rewardBuilder.endReward();
        }

        public RewardsBuilder startReward() {
            return new RewardsBuilder(this);
        }

        public Builder rewards(class_170 advancementRewards) {
            this.builder.method_706(advancementRewards);
            return this;
        }

        public Builder rewardXP(int xp) {
            return this.rewards(class_170.class_171.method_750((int)500).method_751());
        }

        public Builder addCriterion(String string, class_184 criterionTriggerInstance) {
            this.builder.method_705(string, new class_175(criterionTriggerInstance));
            return this;
        }

        public Builder addCriterion(String string, class_175 criterion) {
            this.builder.method_705(string, criterion);
            return this;
        }

        public Builder addAtStructureCriterion(String name, BCLStructure<?> structure) {
            return this.addAtStructureCriterion(name, structure.structureKey);
        }

        public Builder addAtStructureCriterion(String name, class_5321<class_3195> structure) {
            return this.addCriterion(name, (class_184)class_2135.class_2137.method_43137((class_2090)class_2090.method_9017(structure)));
        }

        public <C extends class_1263, T extends class_1860<C>> Builder addRecipeUnlockCriterion(String name, T recipe) {
            return this.addCriterion(name, (class_184)class_2119.method_27847((class_2960)recipe.method_8114()));
        }

        public Builder addInventoryChangedCriterion(String name, class_1935 ... items) {
            return this.addCriterion(name, (class_184)class_2066.class_2068.method_8959((class_1935[])items));
        }

        public Builder addInventoryChangedCriterion(String name, class_6862<class_1792> tag) {
            return this.addCriterion(name, (class_184)class_2066.class_2068.method_8957((class_2073[])new class_2073[]{new class_2073(tag, null, class_2096.class_2100.field_9708, class_2096.class_2100.field_9708, class_2035.field_20687, class_2035.field_20687, null, class_2105.field_9716)}));
        }

        public Builder addEquipmentSetSlotCriterion(EquipmentSet set, String slot) {
            return this.addInventoryChangedCriterion(set.baseName + "_" + slot, new class_1935[]{set.getSlot(slot)});
        }

        public Builder addArmorSetCriterion(EquipmentSet set) {
            return this.addEquipmentSetSlotCriterion(set, "helmet").addEquipmentSetSlotCriterion(set, "chestplate").addEquipmentSetSlotCriterion(set, "leggings").addEquipmentSetSlotCriterion(set, "boots");
        }

        public Builder addToolSetCriterion(EquipmentSet set) {
            return this.addEquipmentSetSlotCriterion(set, "pickaxe").addEquipmentSetSlotCriterion(set, "axe").addEquipmentSetSlotCriterion(set, "shovel").addEquipmentSetSlotCriterion(set, "sword").addEquipmentSetSlotCriterion(set, "hoe");
        }

        public Builder addWoodCriterion(WoodenComplexMaterial mat) {
            return this.addInventoryChangedCriterion(mat.getBaseName(), new class_1935[]{mat.getBlock("log"), mat.getBlock("bark"), mat.getBlock("planks")});
        }

        public Builder addVisitBiomesCriterion(List<class_5321<class_1959>> list) {
            for (class_5321<class_1959> resourceKey : list) {
                this.addCriterion(resourceKey.method_29177().toString(), (class_184)class_2135.class_2137.method_43137((class_2090)class_2090.method_9022(resourceKey)));
            }
            return this;
        }

        public Builder requirements(class_193 requirementsStrategy) {
            this.builder.method_704(requirementsStrategy);
            return this;
        }

        public Builder requirements(String[][] strings) {
            this.builder.method_34884(strings);
            return this;
        }

        public Builder printDebugJson() {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            BCLib.LOGGER.info(gson.toJson((JsonElement)this.builder.method_698()));
            return this;
        }

        public class_2960 buildAndRegister() {
            AdvancementManager.register(this.id, this.builder);
            return this.id;
        }

        public class_2960 buildAndRegister(Map<class_2960, class_161.class_162> map) {
            map.put(this.id, this.builder);
            return this.id;
        }
    }

    public static enum AdvancementType {
        REGULAR,
        RECIPE_DECORATIONS,
        RECIPE_TOOL;

    }

    public static class RewardsBuilder {
        private final Builder calle;
        private final class_170.class_171 builder = new class_170.class_171();

        private RewardsBuilder(Builder calle) {
            this.calle = calle;
        }

        public RewardsBuilder addExperience(int i) {
            this.builder.method_749(i);
            return this;
        }

        public RewardsBuilder addLootTable(class_2960 resourceLocation) {
            this.builder.method_34900(resourceLocation);
            return this;
        }

        public RewardsBuilder addRecipe(class_2960 resourceLocation) {
            this.builder.method_752(resourceLocation);
            return this;
        }

        public RewardsBuilder runs(class_2960 resourceLocation) {
            this.builder.method_34902(resourceLocation);
            return this;
        }

        public Builder endReward() {
            this.calle.rewards(this.builder.method_751());
            return this.calle;
        }
    }
}

